﻿using System;
using System.Collections;

class CollectGenerations
{
    static void Main(string[] args)
    {
        int maxGenerations = GC.MaxGeneration;

        ArrayList heapObjects = new ArrayList();
        string[] IDs = new string[] 
            {"A", "B", "C", "D", "E", "F", "G", 
             "H", "I", "J", "K", "L", "M", "N"};

        for (int i = 0, j = 0; i <= maxGenerations; i++, j += 2)
        {
            Console.WriteLine(
                "\nOczyszczanie pamięci nr {0}: \n", i);

            heapObjects.Add(new AllocatedObject(IDs[j]));
            heapObjects.Add(new AllocatedObject(IDs[j + 1]));

            foreach (AllocatedObject obj in heapObjects)
            {
                obj.TellGeneration();
            }

            GC.Collect();
        }
    }
}

class AllocatedObject
{
    string name;

    public AllocatedObject(string name)
    {
        this.name = name;
    }

    public void TellGeneration()
    {
        Console.WriteLine("Obiekt {0} pochodzi z pokolenia {1}.",
            name, GC.GetGeneration(this));
    }
}
